<?php
/**
 * PvP Rankings
 * https://webenginecms.org/
 * 
 * @version 1.1.0
 * @author Lautaro Angelico <http://lautaroangelico.com/>
 * @copyright (c) 2013-2018 Lautaro Angelico, All Rights Reserved
 * @build w3c8c718b75a0f1fa1a557f7f9d70877
 */

try {
	
	echo '<div class="page-title"><span>'.lang('pvprankings_title',true).'</span></div>';
	
	$Rankings = new Rankings();
	$Rankings->rankingsMenu();
	
	$PVPRankings = new \Plugin\PVPRankings\PVPRankings();
	$pvpRankingsData = $PVPRankings->loadCacheData();
	
	echo '<table class="table rankings-table">';
			echo '<tr>';
				echo '<td>'.lang('pvprankings_txt_1', true).'</td>';
				echo '<td class="text-center">'.lang('pvprankings_txt_2', true).'</td>';
				echo '<td class="text-center">'.lang('pvprankings_txt_3', true).'</td>';
				echo '<td class="text-center">'.lang('pvprankings_txt_4', true).'</td>';
			echo '</tr>';
		foreach($pvpRankingsData as $rankingData) {
			echo '<tr>';
				echo '<td>'.playerProfile($rankingData[0]).'</td>';
				echo '<td class="text-center">'.number_format($rankingData[1]).'</td>';
				echo '<td class="text-center">'.$rankingData[3].'</td>';
				echo '<td class="text-center">'.$PVPRankings->formatRankBadge($rankingData[2]).'</td>';
			echo '</tr>';
		}
	echo '</table>';
	
} catch(Exception $ex) {
	message('error', $ex->getMessage());
}